
/*

************************************************

Warning!  GPSVBX is copyright 1995 by Tim Hogard

You may not make copies of this!

You must let me know you have it.  Please send your
email address to thogard@inmind.com

This is the inital version and if its after
10-19-95 You will want the newer version.
Please contact me about newer versions.

Later versions will be in the public Domain.

************************************************
*/

char *dial_str="ATDT8,3851000\r";
void RadToText(float in,char *buf);
char *dtoa(double x);
//char *init_str[6]={0x10,0xfe,0x0,0x2,0x10,0x3};
//unsigned char init_str[8]={0x10,0xa,0x2,0x8,0,236,0x10,0x3}; // turns off
unsigned char init_str[8]={0x10,0xa,0x2,0x2,0,0xf2,0x10,0x3};//request pos
unsigned char request_str[8]={0x10,0xa,0x2,0x0,0,0x0,0x10,0x3};//reqst template
unsigned char ack_str[8]={0x10,0x6,0x2,0xa,0,0xee,0x10,0x3};//generic Ack
unsigned char nack_str[8]={0x10,0x15,0x2,0xfe,0,0xeb,0x10,0x3};//generic Nack
//  Parts Copyright (C) 1991-93, Microsoft Corporation
//
//---------------------------------------------------------------------------
// Contains control procedure for GPS control
//---------------------------------------------------------------------------

#include <windows.h>
#include "vbapi.h"
#include <string.h>
#include "gps.h"       // Declares Vb3.0 compatable model information
#include "gpsvb2.h"    // Declares Vb2.0 compatable model information
#include "gpsvb1.h"    // Declares Vb1.0 compatable model information


void done(char *r,int rx_size, HCTL hctl);
//---------------------------------------------------------------------------
// Local Prototypes
//---------------------------------------------------------------------------
VOID NEAR PaintCircle(HCTL hctl, HWND hwnd, HDC hdc);
VOID NEAR RecalcArea(HCTL hctl, HWND hwnd);
VOID NEAR FlashCircle(HCTL hctl, HDC hdc);
BOOL NEAR InCircle(HCTL hctl, SHORT xcoord, SHORT ycoord);
VOID NEAR FireClickIn(HCTL hctl, HWND hwnd, SHORT x, SHORT y);
VOID NEAR FireClickOut(HCTL hctl);
HWND NEAR HwndInitFlashPopup(VOID);
VOID NEAR DisplayHelpTopic(CHAR chKeylist, LPSTR lpszKeyword);
BOOL _export FAR PASCAL FlashDlgProc(HWND hDlg, USHORT msg, USHORT wp, LONG lp);


//---------------------------------------------------------------------------
// Global Variables
//---------------------------------------------------------------------------
HANDLE hmodDLL;
WORD   cVbxUsers = 0;
BOOL   fDevTimeInited = FALSE;


//---------------------------------------------------------------------------
// Global Variables for FlashColor dialog
//---------------------------------------------------------------------------
BOOL   fDlgInUse = FALSE;
HCTL   hctlDialog;
USHORT ipropDialog;
LONG   colorOldDialog;


char rx_buf_array[40];
char *rx_buf;
int i,x,last;
int CommDev=0;
//char Request_ID_Msg[]={0x10,0xfe,0x00,0x02,0x10,0x3};
char buf[50];	// misc buffer
//---------------------------------------------------------------------------
// Circle Control Procedure
//---------------------------------------------------------------------------
LONG FAR PASCAL _export CircleCtlProc
(
    HCTL   hctl,
    HWND   hwnd,
    USHORT msg,
    USHORT wp,
    LONG   lp
)
{
HSZ hsz;
int i;
    switch (msg)
	{
	case VBM_DATA_AVAILABLE:
		{
		ERR	err;
		HSZ hszFieldName;
	    LONG lData;
		LPDATAACCESS lpda;

		lpda = (LPDATAACCESS)lp;

		switch (lpda->sAction) {
			case DATA_CLOSE:
			case DATA_DELETE:
			case DATA_UNLOAD:
				VBSetControlFlags(hctl, CTLFLG_DATACHANGED, 0L);
				return 0;
			default:
				break;
		}

		err = (ERR)VBGetControlProperty(hctl, IPROP_CIRCLE_DATAFIELD, &hszFieldName);
		if (err)
			return err;

		if (!hszFieldName || *VBDerefHsz(hszFieldName) == 0) {
			if (hszFieldName)
				VBDestroyHsz(hszFieldName);	
			return 0;
		}

		lpda->hszDataField = hszFieldName;
		lpda->sAction = DATA_FIELDVALUE;
		lpda->usDataType = DT_HSZ;
		lpda->lData = NULL;

		err = (ERR)VBSendControlMsg(lpda->hctlData, VBM_DATA_GET, 0, (LONG)lpda);
		if (err || !lpda->lData) {
			VBDestroyHsz(hszFieldName);
			return err;
		}

		lData = (LONG)VBLockHsz((HSZ)lpda->lData);
		
		VBSetControlFlags(hctl, CTLFLG_DATACHANGED, 0L);
		VBSetControlFlags(hctl, CTLFLG_BOUNDDATASET, CTLFLG_BOUNDDATASET);
		err = VBSetControlProperty(lpda->hctlBound, IPROP_CIRCLE_CAPTION, lData);
		VBSetControlFlags(hctl, CTLFLG_BOUNDDATASET, 0L);

		VBUnlockHsz((HSZ)lpda->lData);
		VBDestroyHsz(hszFieldName);
		VBDestroyHsz((HSZ)lpda->lData);
		return err;
		}

	case VBM_DATA_REQUEST:
		{
		ERR	err;
		HSZ hszCaption;
		HSZ hszFieldName;
		LPDATAACCESS lpda;

		lpda = (LPDATAACCESS)lp;

		if (!(VBSetControlFlags(hctl, 0L, 0L) & CTLFLG_DATACHANGED))
			return 0;
			
		err = (ERR)VBGetControlProperty(hctl, IPROP_CIRCLE_DATAFIELD, &hszFieldName);
		if (err)
			return err;

		if (!hszFieldName || *VBDerefHsz(hszFieldName) == 0) {
			if (hszFieldName)
				VBDestroyHsz(hszFieldName);	
			return 0;
		}

		err = (ERR)VBGetControlProperty(hctl, IPROP_CIRCLE_CAPTION, &hszCaption);
		if (err) {
			VBDestroyHsz(hszFieldName);	
			return err;
		}

		lpda->hszDataField = hszFieldName;
		lpda->sAction = DATA_FIELDVALUE;
		lpda->usDataType = DT_HSZ;
		lpda->lData = hszCaption;

		err = (ERR)VBSendControlMsg(lpda->hctlData, VBM_DATA_SET, 0, (LONG)lpda);
		
		if (!err)
			VBSetControlFlags(hctl, CTLFLG_DATACHANGED, 0L);

		VBDestroyHsz(hszFieldName);
		VBDestroyHsz(hszCaption);
		return err;
		}

	case WM_NCCREATE:
	    {
		LPCIRC lpcirc;

	    /*LPCIRC */lpcirc = (LPCIRC)VBDerefControl(hctl);

	    lpcirc->CircleShape = SHAPE_CIRCLE;
	    lpcirc->FlashColor = 128L;
	    VBSetControlProperty(hctl, IPROP_CIRCLE_BACKCOLOR, 255L);
	    // *** lpcirc may now be invalid due to call to VB API ***
	    break;
	    }

        case WM_COMMNOTIFY:
//		wp==comm device;
//		lp==CN_EVENT;
//		lp==CN_RECIEVE;
//		lp==CN_TRANSMIT;
//		GetCommEventMask(wp,0xffff);	// clear all events
		x=ReadComm(CommDev,buf,sizeof(buf));
		for(i=0;i<x;i++) {
			int c=buf[i];
			switch(0) { // protocol) 
			case PROTO_GRMN:
				if(last==0x10) {
					if(c==0x3) {
						*rx_buf++=0x10;
						*rx_buf++=(char)c;
						done(rx_buf_array,0,hctl);
						rx_buf=rx_buf_array;	//init rx_buffer
						FireClickOut(hctl);
					} else if(c==0x10) {
						*rx_buf++=(char)c;
					} else {
						*rx_buf++=0x10;
						*rx_buf++=(char)c;
					}
					last=0;
				} else {
					if(c==0x10)
						last=c;
					else
						*rx_buf++=(char)c;
				}
				break;
			case PROTO_NMEA:
			case PROTO_RTCM:
				break;
			}
		}
		break;
        case WM_LBUTTONDOWN:
        case WM_LBUTTONDBLCLK:
	    if (InCircle(hctl, (SHORT)lp, (SHORT)HIWORD(lp)))
		{
		HDC hdc = GetDC(hwnd);

		FlashCircle(hctl, hdc);
		ReleaseDC(hwnd, hdc);
		FireClickIn(hctl, hwnd, (SHORT)lp, (SHORT)HIWORD(lp));
		}
	    else
		FireClickOut(hctl);
            break;

        case WM_LBUTTONUP:
	    if (InCircle(hctl, (SHORT)lp, (SHORT)HIWORD(lp)))
		{
		HDC hdc = GetDC(hwnd);

		PaintCircle(hctl, hwnd, hdc);
		ReleaseDC(hwnd, hdc);
		}
            break;

        case WM_SETFONT:
	    LpcircDEREF(hctl)->hfont = (HFONT)wp;
            return 0;

        case WM_GETFONT:
	    return LpcircDEREF(hctl)->hfont;

        case WM_SETTEXT:
            {
	    HSZ    hsz;
	    LPCIRC lpcirc = LpcircDEREF(hctl);

	    if (lpcirc->hszCaption)
		{
		VBDestroyHsz(lpcirc->hszCaption);
		// *** lpcirc may now be invalid due to call to VB API ***
		}
	    hsz = VBCreateHsz((_segment)hctl, (LPSTR)lp);
	    // *** lpcirc may now be invalid due to call to VB API ***
	    LpcircDEREF(hctl)->hszCaption = hsz;
	    InvalidateRect(hwnd, NULL, TRUE);
	    return 0L;
            }

        case WM_GETTEXT:
            {
	    LPSTR  lpstr;
	    USHORT cch;
	    LPCIRC lpcirc = LpcircDEREF(hctl);

	    if (lpcirc->hszCaption == NULL)
		{
		*(LPSTR)lp = 0L;
		wp = 1;
		}
	    else
		{
		lpstr = VBDerefHsz(lpcirc->hszCaption);
		cch = (USHORT)(lstrlen(lpstr) + 1);
		if (wp > cch)
		    wp = cch;
		_fstrncpy((LPSTR)lp, lpstr, wp);
		((LPSTR)lp)[wp - 1] = '\0';
		}
            }
	    return (LONG)(wp - 1);

	case WM_GETTEXTLENGTH:
	    {
	    LPCIRC lpcirc = LpcircDEREF(hctl);

	    if (lpcirc->hszCaption == NULL)
                return 0L;
            else
		return lstrlen(VBDerefHsz(lpcirc->hszCaption));
	    }


        case WM_PAINT:
            if (wp)
		PaintCircle(hctl, hwnd, (HDC)wp);
	    else
		{
                PAINTSTRUCT ps;

		BeginPaint(hwnd, &ps);
		PaintCircle(hctl, hwnd, ps.hdc);
		EndPaint(hwnd, &ps);
		}
            break;

        case WM_SIZE:
	    RecalcArea(hctl, hwnd);
            break;

        case VBM_SETPROPERTY:
	    switch (wp)
		{
//                case IPROP_GPS_SendIDMsg:	//  send an requst of ID
//			WriteComm(CommDev,Request_ID_Msg,6);
 //		   return 0L;
                case IPROP_GPS_Control: switch(*(int *)&lp)  {
			case SEND_NULL:
				break;
			case SEND_ACK:
				WriteComm(CommDev,ack_str,8);	// ACK
				break;
			case SEND_NACK:
				WriteComm(CommDev,nack_str,8);	// ACK
				break;
			case SEND_RESET:
			MessageBox(0,"Dont know how to reset yet",0,0);
			}
		    return 0L;
                case IPROP_GPS_Protocol: if(*(int *)&lp) 
			MessageBox(0,"GRMN is the only protocol for now",0,0);
		    return 0L;
                case IPROP_GPS_Request: if(i=*(int *)&lp) {
	int cs=0;
	cs-=0xa; cs-=0x2;
	cs-=i&0xff; cs-=0;	// ignore high word for now
WriteComm(CommDev,init_str,3);
WriteComm(CommDev,&i,2);
WriteComm(CommDev,&cs,1);
WriteComm(CommDev,&request_str[6],2);
//unsigned char init_str[8]={0x10,0xa,0x2,0x2,0,0xf2,0x10,0x3};//request pos
		}
			return 0L;
                case IPROP_GPS_COMM_PORT: if(*(int *)&lp) {
// open comm

DCB dcb;
int x=0;
CommDev=OpenComm("COM2",512,1024);
rx_buf=rx_buf_array;	//init rx_buffer
if(CommDev<0) {
	wsprintf(buf,"Open Comm err %d",CommDev);
	MessageBox(0,buf,0,0);
}
//CloseComm(CommDev);
//BuildCommDCB("COM2:9600,n,8,1",&dcb);
//BuildCommDCB("COM4:9600,n,8,1",&dcb);
//BuildCommDCB("COM2:9600,n,8,1",&dcb);
//dcb.fOutX=dcb.fInX=0;// turn off xon/off flow control. // should be off already
GetCommState(CommDev,&dcb);
dcb.BaudRate=CBR_9600;
dcb.Parity=NOPARITY;
dcb.fBinary=1;
dcb.ByteSize=8;
SetCommState(&dcb);
EnableCommNotification(CommDev,hwnd,1,2);
//SetCommEventMask(CommDev,EV_RXCHAR);
//SetCommEventMask(CommDev,0xFFFF);
x=WriteComm(CommDev,init_str,8);
if(x!=8) {
	wsprintf(buf,"Write Comm err %d",x);
	MessageBox(0,buf,0,0);
}
	} else {
		CloseComm(CommDev);
	}
	return 0L;
                case IPROP_GPS_LatRad:
RadToText(*(float *)&lp,buf);
hsz=VBCreateHsz((_segment)hctl,(LPSTR)buf);
		    LpcircDEREF(hctl)->LatRad = *(float *)&lp;
		    LpcircDEREF(hctl)->Latitude = hsz;
		    return 0L;
                case IPROP_GPS_MSG_READY:
		    LpcircDEREF(hctl)->MsgReady = (BOOL)lp;
		    return 0L;
                case IPROP_CIRCLE_CIRCLESHAPE:
		    LpcircDEREF(hctl)->CircleShape = (ENUM)lp;
		    RecalcArea(hctl, hwnd);
		    InvalidateRect(hwnd, NULL, TRUE);
		    return 0L;

                case IPROP_CIRCLE_CAPTION:
					VBSetControlFlags(hctl, CTLFLG_DATACHANGED, CTLFLG_DATACHANGED);
		}
            break;

	case VBM_HELP:
	    switch (LOBYTE(wp))
		{
		case VBHELP_PROP:
		    // High byte identifies which property.
		    // Keyword is: "<property>"
		    switch (HIBYTE(wp))
			{
case IPROP_CIRCLE_CIRCLESHAPE: DisplayHelpTopic('P', "CircleShape"); return 0L;
case IPROP_CIRCLE_FLASHCOLOR: DisplayHelpTopic('P', "FlashColor"); return 0L;
case IPROP_GPS_COMM_PORT: DisplayHelpTopic('P', "CommPort"); return 0L;
case IPROP_GPS_MSG_READY: DisplayHelpTopic('P', "Msg_Ready"); return 0L;
case IPROP_GPS_SendIDMsg: DisplayHelpTopic('P', "SendIDMsg"); return 0L;
case IPROP_GPS_LatRad: DisplayHelpTopic('P', "LatRad"); return 0L;
case IPROP_GPS_Latitude: DisplayHelpTopic('P', "Latitude"); return 0L;
case IPROP_GPS_LonRad: DisplayHelpTopic('P', "LonRad"); return 0L;
case IPROP_GPS_Longitude: DisplayHelpTopic('P', "Longitude"); return 0L;
case IPROP_GPS_Request: DisplayHelpTopic('P', "Request"); return 0L;
case IPROP_GPS_Protocol: DisplayHelpTopic('P', "Protocol"); return 0L;
case IPROP_GPS_Control: DisplayHelpTopic('P', "Control"); return 0L;
			}
		    break;

		case VBHELP_EVT:
		    // High byte identifies which event
		    // Keyword is: "<event>"
		    switch (HIBYTE(wp))
			{
			case IEVENT_CIRCLE_CLICKIN:
			    DisplayHelpTopic('V', "ClickIn");
			    return 0L;

			case IEVENT_CIRCLE_CLICKOUT:
			    DisplayHelpTopic('V', "ClickOut");
			    return 0L;
			}
		    break;

		case VBHELP_CTL:
		    // High byte is unused.
		    // Keyword is: "<classname>"
		    DisplayHelpTopic('C', "GPS");
		    return 0L;
		}
	    break;

        case VBM_INITPROPPOPUP:
	    switch (wp)
		{
		// Un-commenting the following line will enable our custom
		// popup instead of the color palette, when setting the
		// backcolor:
		// case IPROP_CIRCLE_BACKCOLOR:
		case IPROP_CIRCLE_FLASHCOLOR:
		    {
		    if (fDlgInUse)
		      // Our dialog is already in use, so return NULL here
		      // to avoid bringing up a 2nd instance of the dialog.
		      // We could get around this restriction by storing
		      // hctlDialog, ipropDialog, and colorOldDialog as
		      // window words of hwndPopup.
		      // NOTE: In this specific case, because FlashColor
		      // is DT_COLOR, we could also just "break;" to go
		      // through default processing which would bring up
		      // the default color palette.
		      return NULL;

		    // Tell the hwndPopup which control and iprop we want
		    // the dialog to change
		    fDlgInUse	= TRUE;
		    hctlDialog	= hctl;
		    ipropDialog = wp;

		    return HwndInitFlashPopup();
		    }
                }
            break;
	}

    return VBDefControlProc(hctl, hwnd, msg, wp, lp);
}


//---------------------------------------------------------------------------
// Handle painting by drawing circle into the given hdc.
//---------------------------------------------------------------------------
VOID NEAR PaintCircle
(
    HCTL hctl,
    HWND hwnd,
    HDC  hdc
)
{
    HBRUSH hbr;
    HBRUSH hbrOld = NULL;
    LPSTR  lpstr;
    LPCIRC lpcirc = LpcircDEREF(hctl);
    LPRECT lprect = &lpcirc->rectDrawInto;
    HFONT  hfontOld = NULL;

    hbr = (HBRUSH)SendMessage(GetParent(hwnd), WM_CTLCOLOR,
			      hdc, MAKELONG(hwnd, 0));
    if (hbr)
	hbrOld = SelectObject(hdc, hbr);
    Ellipse(hdc, lprect->left, lprect->top, lprect->right, lprect->bottom);

    if (lpcirc->hfont)
      hfontOld = SelectObject(hdc, lpcirc->hfont);
    lpstr = VBDerefHsz(lpcirc->hszCaption);
    DrawText(hdc, lpstr, -1, lprect, DT_VCENTER | DT_CENTER | DT_SINGLELINE);

    if (hbrOld)
	SelectObject(hdc, hbrOld);
    if (hfontOld)
	SelectObject(hdc, hfontOld);
}


//---------------------------------------------------------------------------
// Paint the circle in the FlashColor.
//---------------------------------------------------------------------------
VOID NEAR FlashCircle
(
    HCTL hctl,
    HDC  hdc
)
{
    HBRUSH hbr;
    HBRUSH hbrOld = NULL;
    LPCIRC lpcirc = LpcircDEREF(hctl);
    LPRECT lprect = &lpcirc->rectDrawInto;

    hbr = CreateSolidBrush(RGBCOLOR(lpcirc->FlashColor));
    if (hbr)
	hbrOld = SelectObject(hdc, hbr);
    Ellipse(hdc, lprect->left, lprect->top, lprect->right, lprect->bottom);
    if (hbr)
	{
	SelectObject(hdc, hbrOld);
	DeleteObject(hbr);
	}
}


//---------------------------------------------------------------------------
// Use the hwnd's client size to determine the bounding rectangle for the
// circle.  If CircleShape is TRUE, then we need to calculate a square
// centered in lprect.
//---------------------------------------------------------------------------
VOID NEAR RecalcArea
(
    HCTL hctl,
    HWND hwnd
)
{
    LPCIRC lpcirc = LpcircDEREF(hctl);
    LPRECT lprect = &lpcirc->rectDrawInto;

    GetClientRect(hwnd, lprect);
    if (lpcirc->CircleShape == SHAPE_OVAL)
        return;
    if (lprect->right > lprect->bottom)
	{
	lprect->left = (lprect->right - lprect->bottom) / 2;
	lprect->right = lprect->left + lprect->bottom;
	}
    else if (lprect->bottom > lprect->right)
	{
	lprect->top = (lprect->bottom - lprect->right) / 2;
	lprect->bottom = lprect->top + lprect->right;
	}
}


//---------------------------------------------------------------------------
// Return TRUE if the given coordinates are inside of the circle.
//---------------------------------------------------------------------------
BOOL NEAR InCircle
(
    HCTL  hctl,
    SHORT xcoord,
    SHORT ycoord
)
{
    double a, b;
    double x, y;
    LPRECT lprect = &LpcircDEREF(hctl)->rectDrawInto;

    a = (lprect->right - lprect->left) / 2;
    b = (lprect->bottom - lprect->top) / 2;
    x = xcoord - (lprect->left + lprect->right) / 2;
    y = ycoord - (lprect->top + lprect->bottom) / 2;
    return ((x * x) / (a * a) + (y * y) / (b * b) <= 1);
}


//---------------------------------------------------------------------------
// TYPEDEF for parameters to the ClickIn event.
//---------------------------------------------------------------------------
typedef struct tagCLICKINPARMS
    {
    HLSTR      ClickString;
    float far *Y;
    float far *X;
    LPVOID     Index;
    } CLICKINPARMS;


//---------------------------------------------------------------------------
// Fire the ClickIn event, passing the x,y coords of the click.  Also pass
// the current caption of the Circle control, to demonstrate passing strings
// to event procedures.
//---------------------------------------------------------------------------
VOID NEAR FireClickIn
(
    HCTL  hctl,
    HWND  hwnd,
    SHORT x,
    SHORT y
)
{
    CLICKINPARMS params;
    float	 xTwips, yTwips;
    USHORT	 cbCaption, err;
    char	 strBuf[20];

    xTwips = (float)VBXPixelsToTwips(x);
    yTwips = (float)VBYPixelsToTwips(y);
    params.X = &xTwips;
    params.Y = &yTwips;

    cbCaption = (USHORT)GetWindowText(hwnd, strBuf, 20);
    params.ClickString = VBCreateHlstr(strBuf, cbCaption);
    err = VBFireEvent(hctl, IEVENT_CIRCLE_CLICKIN, &params);
    VBDestroyHlstr(params.ClickString);
}


//---------------------------------------------------------------------------
// Fire the ClickOut event.
//---------------------------------------------------------------------------
VOID NEAR FireClickOut
(
    HCTL hctl
)
{
    VBFireEvent(hctl, IEVENT_CIRCLE_CLICKOUT, NULL);
}


//---------------------------------------------------------------------------
// Use frame variables to "allocate" a MULTIKEYHELP structure to pass to
// WinHelp().
//---------------------------------------------------------------------------
VOID NEAR DisplayHelpTopic
(

    CHAR  chKeylist,
    LPSTR lpszKeyword
)
{
    char  rgch[100];
    MULTIKEYHELP FAR *lpmkh = rgch;

    lpmkh->mkSize = sizeof(MULTIKEYHELP) + lstrlen(lpszKeyword);
    if (lpmkh->mkSize > sizeof(rgch))
	return;

    lpmkh->mkKeylist = chKeylist;
    lstrcpy((LPSTR)lpmkh->szKeyphrase, lpszKeyword);
    WinHelp(GetActiveWindow(), "gps.hlp", HELP_MULTIKEY, (DWORD)lpmkh);
}


//---------------------------------------------------------------------------
// Create our property popup-window.  Since we want to put up a dialog, this
// window never becomes visible.  Instead, when asked to become visible, it
// will post a message to itself, remining it to put up our dialog.
//
// NOTE: May return NULL!
//---------------------------------------------------------------------------
HWND NEAR HwndInitFlashPopup
(
    VOID
)
{
    return CreateWindow(CLASS_FLASHPOPUP, NULL, WS_POPUP,
			0, 0, 0, 0, NULL, NULL,
			hmodDLL, NULL);
}


//---------------------------------------------------------------------------
// We asked to show ourself, remain invisible and post a CM_OPENFLASHDLG to
// ourself.  When we receive this message, open the dialog box.
//---------------------------------------------------------------------------
LONG _export FAR PASCAL FlashPopupWndProc
(
    HWND   hwnd,
    USHORT msg,
    USHORT wp,
    LONG   lp
)
{
    extern HANDLE hmodDLL;

    switch (msg)
	{
	case WM_DESTROY:
	    fDlgInUse = FALSE;
	    break;

        case WM_SHOWWINDOW:
	    if (wp)
		{
		PostMessage(hwnd, CM_OPENFLASHDLG, 0, 0L);
		return 0L;
		}
            break;

	case CM_OPENFLASHDLG:
	    VBDialogBoxParam(hmodDLL, "FlashDlg", (FARPROC)FlashDlgProc, 0L);
	    return 0L;
	}

    return DefWindowProc(hwnd, msg, wp, lp);
}


//---------------------------------------------------------------------------
// An array mapping option buttons to RGB colors.
//---------------------------------------------------------------------------
long mpidcolor[] = { 0xff, 0xff00, 0xff0000 };


//---------------------------------------------------------------------------
// The Dialog Procedure for the FlashColor property dialog.
//---------------------------------------------------------------------------
BOOL FAR PASCAL _export FlashDlgProc
(
    HWND   hDlg,
    USHORT msg,
    USHORT wp,
    LONG   lp
)
{
    switch (msg)
	{
	case WM_INITDIALOG:
	    {
	    RECT rect;
	    int  nx, ny;	  // New x and y
	    int  width, height;
	    int  i;
	    LONG colorOld;

	    // Position dialog so it looks nice:
	    GetWindowRect(hDlg, &rect);
	    width  = rect.right - rect.left;
	    height = rect.bottom - rect.top;
	    nx = (GetSystemMetrics(SM_CXSCREEN) - width)  / 2;
	    ny = (GetSystemMetrics(SM_CYSCREEN) - height) / 3;
	    MoveWindow(hDlg, nx, ny, width, height, FALSE);

	    // Remember the old value of this property, so we can restore it
	    // on cancel:
	    if (VBGetControlProperty(hctlDialog, ipropDialog, &colorOld))
	      EndDialog(hDlg, FALSE);

	    // If the current color matches one of the option button colors,
	    // then set that option button:
	    for (i=0; i<sizeof(mpidcolor); i++)
		if (mpidcolor[i] == colorOld)
		    CheckRadioButton(hDlg, DI_REDOPT, DI_BLUEOPT, i+DI_REDOPT);

	    // Save away colorOld so we can use it later
	    colorOldDialog = colorOld;

	    return TRUE;
	    }

        case WM_COMMAND:
	    switch (wp)
		{
                case IDOK:
		    EndDialog(hDlg, TRUE);
                    return TRUE;

		case IDCANCEL:
		    {
		    // Restore the old value, since we're canceling:
		    VBSetControlProperty(hctlDialog, ipropDialog, colorOldDialog);

		    EndDialog(hDlg, FALSE);
		    return TRUE;
		    }

                case DI_REDOPT:
                case DI_GREENOPT:
		case DI_BLUEOPT:
		    {
		    CheckRadioButton(hDlg, DI_REDOPT, DI_BLUEOPT, wp);

		    VBSetControlProperty(hctlDialog, ipropDialog,
					 mpidcolor[wp-DI_REDOPT]);
		    return TRUE;
		    }
		}
            break;
	}
    return FALSE;
}


//---------------------------------------------------------------------------
// Register custom control. This routine is called by VB when the custom
// control DLL is loaded for use.
//---------------------------------------------------------------------------
BOOL FAR PASCAL _export VBINITCC
(
    USHORT usVersion,
    BOOL   fRuntime
)
{
    // Count the number of hosts using this VBX.  A host can be vb.exe,
    // any .exe compiled from vb which uses this custom control, or any
    // other program which loads and uses VBX files.
    ++cVbxUsers;

    // Register popup class if this is from the development environment.
    if (!fRuntime && !fDevTimeInited)
	{
	WNDCLASS class;

	class.style	    = 0;
	class.lpfnWndProc   = (FARPROC)FlashPopupWndProc;
	class.cbClsExtra    = 0;
	class.cbWndExtra    = 0;
	class.hInstance     = hmodDLL;
	class.hIcon	    = NULL;
	class.hCursor	    = NULL;
        class.hbrBackground = NULL;
	class.lpszMenuName  = NULL;
	class.lpszClassName = CLASS_FLASHPOPUP;

	if (!RegisterClass(&class))
	    return FALSE;

	// We successfully initialized the stuff we need at dev time
	fDevTimeInited = TRUE;
	}

    // Register control(s)
    if (usVersion <= VB100_VERSION)
		return VBRegisterModel(hmodDLL, &modelCircle_Vb1);

    if (usVersion <= VB200_VERSION)
		return VBRegisterModel(hmodDLL, &modelCircle_Vb2);
	else
		return VBRegisterModel(hmodDLL, &modelCircle);
}


//---------------------------------------------------------------------------
// Unregister custom control.  This routine is called by VB when the custom
// control DLL is being unloaded.
//---------------------------------------------------------------------------
VOID FAR PASCAL _export VBTERMCC
(
    VOID
)
{
    --cVbxUsers;
    if (cVbxUsers == 0 && fDevTimeInited)
	{
	// Free any resources created for Dev environment
	UnregisterClass(CLASS_FLASHPOPUP, hmodDLL);
	}
    return;
}


//---------------------------------------------------------------------------
// Provide custom control model information to host environment.
//---------------------------------------------------------------------------
LPMODELINFO FAR PASCAL _export VBGetModelInfo
(
    USHORT usVersion
)
{
    if (usVersion <= VB100_VERSION)
		return &modelinfoCircle_Vb1;

    if (usVersion <= VB200_VERSION)
		return &modelinfoCircle_Vb2;
    else
		return &modelinfoCircle;
}


//---------------------------------------------------------------------------
// Initialize library.	This routine is called when the first client loads
// the DLL.
//---------------------------------------------------------------------------
int FAR PASCAL LibMain
(
    HANDLE hModule,
    WORD   wDataSeg,
    WORD   cbHeapSize,
    LPSTR  lpszCmdLine
)
{
    // Avoid warnings on unused (but required) formal parameters
    wDataSeg	= wDataSeg;
    cbHeapSize	= cbHeapSize;
    lpszCmdLine = lpszCmdLine;

    hmodDLL = hModule;

    return 1;
}


//---------------------------------------------------------------------------
// WEP
//---------------------------------------------------------------------------
// C7 and QCWIN provide default a WEP:
//---------------------------------------------------------------------------
//#if (_MSC_VER < 610)
#if (1)

int FAR PASCAL WEP(int fSystemExit);

//---------------------------------------------------------------------------
// For Windows 3.0 it is recommended that the WEP function reside in a
// FIXED code segment and be exported as RESIDENTNAME.  This is
// accomplished using the alloc_text pragma below and the related EXPORTS
// and SEGMENTS directives in the .DEF file.
//
// Read the comments section documenting the WEP function in the Windows
// 3.1 SDK "Programmers Reference, Volume 2: Functions" before placing
// any additional code in the WEP routine for a Windows 3.0 DLL.
//---------------------------------------------------------------------------
#pragma alloc_text(WEP_TEXT,WEP)

//---------------------------------------------------------------------------
// Performs cleanup tasks when the DLL is unloaded.  WEP() is
// called automatically by Windows when the DLL is unloaded (no
// remaining tasks still have the DLL loaded).	It is strongly
// recommended that a DLL have a WEP() function, even if it does
// nothing but returns success (1), as in this example.
//---------------------------------------------------------------------------
int FAR PASCAL WEP
(
    int fSystemExit
)
{
    // Avoid warnings on unused (but required) formal parameters
    fSystemExit = fSystemExit;

    return 1;
}
#endif // C6

//---------------------------------------------------------------------------
// convert float to degrees 
void RadToText(float in, char *buf) { 
	double deg;
	int d,m,s;	//deg,min,sec
	deg=360.0*in/6.28318530718;
	d=deg;
	deg=deg-d;
	deg*=60.0;	
	m=deg;
	deg=deg-m;
	deg*=60.0;
	s=deg;
	wsprintf(buf,"%d%c%d'%d\"",d,0xb0,m,s);
}

#define ref_double(x) (*(double *)&x)
#define ref_long(x) (*(long *)&x)
#define ref_int(x) (*(int *)&x)
void done(char *r,int rx_size, HCTL hctl) {
HSZ hsz;
double lat;
	if(r[0]!=0x10)
		MessageBox(0,"Message start not 0x10!",0,0);
	switch(r[1]) {
	case 0x06:	// ack
		break;
	case 0xe: {	// Time
		double t=0;
    DATE_PARMS params;
	int m=r[3],d=r[4],h=r[7],mi=r[9],s=r[10],o=r[8];
	params.dateserial=&t;
	params.month=&m;
	params.day=&d;
	params.year=(int *)&r[5];
	params.hour=&h;
	params.offset=&o;
	params.minute=&mi;
	params.second=&s;
	params.count=(long *)&r[11];
    VBFireEvent(hctl, IEVENT_GPS_DATE, &params);
		}
		break;
	case 0x1b: {	// begin transfer
	TRANSFER_PARAMS params;
	params.type=(int *)&r[3];
    VBFireEvent(hctl, IEVENT_GPS_TRANSFER, &params);
	WriteComm(CommDev,ack_str,8);	// ACK
		}
		break;
	case 0x22:	// track
	case 0x1f:	// Almanac
		{
		ALMANAC_PARAMS params;
		params.week=(int *)&r[3];
		params.time=(long *)&r[5];
		params.af0=(float *)&r[9];
		params.af1=(float *)&r[13];
		params.ecc=(float *)&r[17];
		params.sqrta=(float *)&r[21];
		params.anon=(float *)&r[25];
		params.per=(float *)&r[29];
		params.ra=(float *)&r[33];
		params.rra=(float *)&r[37];
		params.oi=&r[41];
		VBFireEvent(hctl, IEVENT_GPS_ALMANAC, &params);
	WriteComm(CommDev,ack_str,8);	// ACK
		}
		break;
	case 0x11:	// Real position
		{
		POSITION_PARAMS params;
		lat=ref_double(r[3]);
params.lat=&lat;
		LpcircDEREF(hctl)->LatRad=lat;
		RadToText((float)lat,buf);
		hsz = VBCreateHsz((_segment)hctl, (LPSTR)buf);   // delete
		LpcircDEREF(hctl)->Latitude=hsz;

		lat=ref_double(r[11]);
params.lon=&lat;
		LpcircDEREF(hctl)->LonRad=lat;
		RadToText((float)lat,buf);
		hsz = VBCreateHsz((_segment)hctl, (LPSTR)buf);   // delete
		LpcircDEREF(hctl)->Longitude=hsz;
		VBFireEvent(hctl, IEVENT_GPS_POSITION, &params);
		break;
		}
	default:
		wsprintf(buf,"Message %02x %02x %02x %02x %02x %02x %02x %02x",
		r[0], r[1], r[2], r[3], r[4], r[5], r[6], r[7]);
		MessageBox(0,buf,0,0);
	break;
	}
	r[0]=r[1]=r[2]=r[3]=r[4]=r[5]=r[6]=r[7]=0;
}

char *dtoa(double x) {
	static char buf[20];
	long i,j;
	i=x;
	x-=i;
	j=x*10000.0;	
	wsprintf(buf,"%ld.%05ld",i,j);
	return buf;
}
