//---------------------------------------------------------------------------
//		Copyright (C) 1991-93, Microsoft Corporation
//
// You have a royalty-free right to use, modify, reproduce and distribute
// the Sample Custom Control Files (and/or any modified version) in any way
// you find useful, provided that you agree that Microsoft has no warranty,
// obligation or liability for any Custom Control File.
//---------------------------------------------------------------------------
// Circ3.h
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Resource Information
//---------------------------------------------------------------------------
// Toolbox bitmap resource IDs numbers.
//---------------------------------------------------------------------------
#define IDBMP_CIRCLE		8000
#define IDBMP_CIRCLEDOWN	8001
#define IDBMP_CIRCLEMONO	8003
#define IDBMP_CIRCLEEGA 	8006

//---------------------------------------------------------------------------
// Change these for each new VBX file
//---------------------------------------------------------------------------
#define VBX_COMPANYNAME 	   "Microsoft Corporation\0"
#define VBX_FILEDESCRIPTION	   "Visual Basic Circle Custom Control Example\0"
#define VBX_INTERNALNAME	   "GPS\0"
#define VBX_LEGALCOPYRIGHT	   "Copyright \251 Microsoft Corp. 1991-93\0"
#define VBX_LEGALTRADEMARKS	   "Microsoft\256 is a registered trademark of Microsoft Corporation. Visual Basic\231 is a trademark of Microsoft Corporation. Windows\231 is a trademark of Microsoft Corporation.\0"
#define VBX_ORIGINALFILENAME	   "GPS.VBX\0"
#define VBX_PRODUCTNAME 	   "Microsoft\256 Visual Basic\231 for Windows\231\0"

//---------------------------------------------------------------------------
// Update these fields for each build.
//---------------------------------------------------------------------------
#define VBX_VERSION		    3,00,0,00
#define VBX_VERSION_STR 	   "3.00.000\0"

//---------------------------------------------------------------------------
// Constants used by dialog boxes
//---------------------------------------------------------------------------
#define DI_OK	      1
#define DI_CANCEL     2
#define DI_REDOPT     105
#define DI_GREENOPT   106
#define DI_BLUEOPT    107

#ifndef RC_INVOKED
//---------------------------------------------------------------------------
// Macro for referencing member of structure
//---------------------------------------------------------------------------
#define OFFSETIN(struc, field)	    ((USHORT)&(((struc *)0)->field))


//---------------------------------------------------------------------------
// Control and Window Procedures
//---------------------------------------------------------------------------
LONG FAR PASCAL _export CircleCtlProc(HCTL, HWND, USHORT, USHORT, LONG);
LONG FAR PASCAL _export FlashPopupWndProc(HWND hwnd, USHORT msg, USHORT wp, LONG lp);


//---------------------------------------------------------------------------
// Global Variables and Constants
//---------------------------------------------------------------------------
extern	HANDLE hmodDLL;     // From ccinit.c
#define CLASS_FLASHPOPUP    "FCPopup"


//---------------------------------------------------------------------------
// CIRCLE control data and structs
//---------------------------------------------------------------------------
typedef struct tagCIRC
    {
    RECT    rectDrawInto;
    ENUM    CircleShape;    // Changed from SHORT to demonstrate ENUM prop
    LONG    FlashColor;
    HFONT   hfont;
    HSZ     hszCaption;
    SHORT   CommPort;
    BOOL    MsgReady;
    float  LatRad;	// float lat since VB won't support doubles
    float  LonRad;	// float longitude
    HSZ     Latitude;	// text lat
    HSZ     Longitude;	// text longitude
    ENUM    Request;    // Send request
    ENUM    Control;    // control, ack, nack, reset
    } CIRC;

typedef CIRC FAR * LPCIRC;

#define LpcircDEREF(hctl)     ((LPCIRC)VBDerefControl(hctl))


//---------------------------------------------------------------------------
// Private messages
//---------------------------------------------------------------------------
#define CM_OPENFLASHDLG     WM_USER


//---------------------------------------------------------------------------
// Property info
//---------------------------------------------------------------------------
// List of enumeration for CircleShape ENUM property
#define SHAPE_CIRCLE	0
#define SHAPE_OVAL	1
#define SHAPE_MAX	1

PROPINFO Property_CircleShape =
    {
    "CircleShape",
    // Changed from SHORT to demonstrate an ENUM property
    DT_ENUM | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(CIRC, CircleShape),
	0,
    SHAPE_CIRCLE,
    "0 - Circle\0" "1 - Oval\0" "\0",
	SHAPE_MAX
    };

PROPINFO Property_CommPort =
    {
    "CommPort",
    DT_ENUM | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(CIRC, CommPort),
	0,
    0,	//default
    "0 - None\0" "1 - Com1:\0" "2 - Com2:\0" "\0",
	2	// MAX
    };

PROPINFO Property_MsgReady =
    {
    "MsgReady",
    DT_BOOL | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(CIRC, MsgReady),
	0, 0, NULL, 0
    };

PROPINFO Property_SendIDMsg =
    {
    "SendIDMsg",
    DT_BOOL | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(CIRC, MsgReady),
	0, 0, NULL, 0
    };

PROPINFO Property_FlashColor =
    {
    "FlashColor",
    DT_COLOR | PF_fGetData | PF_fSetData | PF_fSaveData | PF_fEditable,
    OFFSETIN(CIRC, FlashColor),
	0, 0, NULL, 0
    };

PROPINFO Property_LatRad =
    {
    "LatRad",
    DT_REAL | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(CIRC, LatRad),
	0, 0, NULL, 0
    };

PROPINFO Property_Latitude =
    {
    "Latitude",
    DT_HSZ | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(CIRC, Latitude),
	0, 0, NULL, 0
    };

PROPINFO Property_LonRad =
    {
    "LonRad",
    DT_REAL | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(CIRC, LonRad),
	0, 0, NULL, 0
    };

PROPINFO Property_Longitude =
    {
    "Longitude",
    DT_HSZ | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(CIRC, Longitude),
	0, 0, NULL, 0
    };

PROPINFO Property_Request =
    {
    "Request",
    DT_ENUM | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(CIRC, Request),
	0,
    0,	//default
    "0 - None\0"
"1 - Almanac\0"
"2 - Position\0"
"3 - Proximity Waypoints\0"
"4 - Route\0"
"5 - Clock\0"
"6 - Track\0"
"7 - Waypoints\0"
"8 - Power Off\0"
"9 - None\0"
"10 - None\0"
"11 - Test (Reset&Off)\0"
"\0",
	65535	// MAX
    };

// protocols supported
enum { PROTO_GRMN, PROTO_NMEA, PROTO_RTCM};
PROPINFO Property_Protocol =
    {
    "Protocol",
    DT_ENUM | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(CIRC, CircleShape),
	0,
    PROTO_GRMN,
    "0 - Grmn\0" "1 - NMEA\0" "2 - RTCM\0",
	PROTO_RTCM
    };

// send ack/nack/nothing
enum { SEND_NULL,SEND_ACK,SEND_NACK,SEND_RESET };
PROPINFO Property_Control =
    {
    "Control",
    DT_ENUM | PF_fGetData | PF_fSetMsg | PF_fSaveData,
    OFFSETIN(CIRC, Control),
	0,
    SEND_NULL,
    "0 - Ready\0" "1 - Send Ack\0" "2 - Send Nack\0" "3 - Reset",
	SEND_RESET
    };

//---------------------------------------------------------------------------
// Property list
//---------------------------------------------------------------------------
// Define the consecutive indicies for the properties
//---------------------------------------------------------------------------
#define IPROP_CIRCLE_CTLNAME		  0
#define IPROP_CIRCLE_INDEX                1
#define IPROP_CIRCLE_BACKCOLOR            2
#define IPROP_CIRCLE_LEFT                 3
#define IPROP_CIRCLE_TOP                  4
#define IPROP_CIRCLE_WIDTH                5
#define IPROP_CIRCLE_HEIGHT               6
#define IPROP_CIRCLE_VISIBLE              7
#define IPROP_CIRCLE_PARENT               8
#define IPROP_CIRCLE_DRAGMODE             9
#define IPROP_CIRCLE_DRAGICON            10
#define IPROP_CIRCLE_TAG                 11
#define IPROP_CIRCLE_CIRCLESHAPE         12
#define IPROP_CIRCLE_FLASHCOLOR          13
#define IPROP_CIRCLE_CAPTION             14
#define IPROP_CIRCLE_FONTNAME            15
#define IPROP_CIRCLE_FONTBOLD            16
#define IPROP_CIRCLE_FONTITALIC          17
#define IPROP_CIRCLE_FONTSTRIKE          18
#define IPROP_CIRCLE_FONTUNDER           19
#define IPROP_CIRCLE_FONTSIZE            20
#define IPROP_CIRCLE_BORDERSTYLE	 21
#define IPROP_CIRCLE_TABINDEX		 22
#define IPROP_CIRCLE_TABSTOP		 23
#define IPROP_CIRCLE_ENABLED		 24
#define IPROP_CIRCLE_MOUSEPOINTER	 25
#define IPROP_CIRCLE_HWND            26
#define IPROP_CIRCLE_HELPCONTEXTID   27
#define IPROP_CIRCLE_DATASOURCE      28
#define IPROP_CIRCLE_DATAFIELD       29
#define IPROP_CIRCLE_DATACHANGED     30
#define IPROP_GPS_COMM_PORT     31
#define IPROP_GPS_MSG_READY     32
#define IPROP_GPS_SendIDMsg     33
#define IPROP_GPS_LatRad     34
#define IPROP_GPS_Latitude     35
#define IPROP_GPS_LonRad     36
#define IPROP_GPS_Longitude     37
#define IPROP_GPS_Request     38
#define IPROP_GPS_Protocol     39
#define IPROP_GPS_Control     40

PPROPINFO Circle_Properties[] =
    {
    PPROPINFO_STD_CTLNAME,
    PPROPINFO_STD_INDEX,
    PPROPINFO_STD_BACKCOLOR,
    PPROPINFO_STD_LEFT,
    PPROPINFO_STD_TOP,
    PPROPINFO_STD_WIDTH,
    PPROPINFO_STD_HEIGHT,
    PPROPINFO_STD_VISIBLE,
    PPROPINFO_STD_PARENT,
    PPROPINFO_STD_DRAGMODE,
    PPROPINFO_STD_DRAGICON,
    PPROPINFO_STD_TAG,
    &Property_CircleShape,
    &Property_FlashColor,
    PPROPINFO_STD_CAPTION,
    PPROPINFO_STD_FONTNAME,
    PPROPINFO_STD_FONTBOLD,
    PPROPINFO_STD_FONTITALIC,
    PPROPINFO_STD_FONTSTRIKE,
    PPROPINFO_STD_FONTUNDER,
    PPROPINFO_STD_FONTSIZE,
    PPROPINFO_STD_BORDERSTYLEOFF,
    PPROPINFO_STD_TABINDEX,
    PPROPINFO_STD_TABSTOP,
    PPROPINFO_STD_ENABLED,
    PPROPINFO_STD_MOUSEPOINTER,
    PPROPINFO_STD_HWND,
    PPROPINFO_STD_HELPCONTEXTID,
    PPROPINFO_STD_DATASOURCE,
    PPROPINFO_STD_DATAFIELD,
    PPROPINFO_STD_DATACHANGED,
    &Property_CommPort,
    &Property_MsgReady,
    &Property_SendIDMsg,
    &Property_LatRad,
    &Property_Latitude,
    &Property_LonRad,
    &Property_Longitude,
    &Property_Request,
    &Property_Protocol,
    &Property_Control,
    NULL
    };


//---------------------------------------------------------------------------
// Event info
//---------------------------------------------------------------------------
WORD Paramtypes_ClickIn[] = {ET_R4, ET_R4, ET_SD};

EVENTINFO Event_ClickIn =
    {
    "ClickIn",
    3,
    6,
    Paramtypes_ClickIn,
    "X As Single,Y As Single,Caption As String"
    };

EVENTINFO Event_ClickOut =
    {
    "ClickOut",
    0,
    0,
    NULL,
    NULL
    };

WORD Paramtypes_Position[] = {ET_R8, ET_R8};
EVENTINFO Event_Position =
    {
    "Position",
    2,
    4,
    Paramtypes_Position,
    "Latitude as Double, Longitude As Double"
    };

//---------------------------------------------------------------------------
// TYPEDEF for parameters to the Date event.
//---------------------------------------------------------------------------
typedef struct tagPOSITION_PARAMS
    {
    double far *lon;
    double far *lat;
    LPVOID     Index;
    } POSITION_PARAMS;

WORD Paramtypes_Date[] = {ET_R8, ET_I2, ET_I2, ET_I2, ET_I2,
 ET_I2, ET_I2,
ET_I2,  ET_I4};
EVENTINFO Event_Date =
    {
    "Date",
    9,
    18,
    Paramtypes_Date,
"CDateSerial as Double, cMonth as Integer, cDay as Integer,"
"cYear as Integer, cHour as Integer, cMinute as Integer,"
"cSecond as Integer, cOffset as Integer, cCounter as Long"
    };

//---------------------------------------------------------------------------
// TYPEDEF for parameters to the Date event.
//---------------------------------------------------------------------------
typedef struct tagDATE_PARMS
    {
    long far *count;
    int far *offset;
    int far *second;
    int far *minute;
    int far *hour;
    int far *year;
    int far *day;
    int far *month;
    double far *dateserial;
    LPVOID     Index;
    } DATE_PARMS;


//---------------------------------------------------------------------------
// TYPEDEF for parameters to the Transfer event.
//---------------------------------------------------------------------------
WORD Paramtypes_Transfer[] = {ET_I2};
typedef struct tagDATE_TRANSFER
    {
    int far *type;
    LPVOID     Index;
    } TRANSFER_PARAMS;
  
EVENTINFO Event_Transfer =
    {
    "Transfer",
    1,
    2,
    Paramtypes_Transfer,
	"Type as Integer"
    };

//---------------------------------------------------------------------------
// TYPEDEF for parameters to the Alminac Record event.
//---------------------------------------------------------------------------
//			      week   Time   Af0    Af1    Ecc    Sqrt(A)
WORD Paramtypes_Almanac[] = {ET_I2, ET_R4, ET_R4, ET_R4, ET_R4, ET_R4,
//Anon Perig  RA     RARate OrbInc
ET_R4, ET_R4, ET_R4, ET_R4, ET_R4 };
   
typedef struct tagDATE_ALMANAC
    {
    float far *oi;
    float far *rra;
    float far *ra;
    float far *per;
    float far *anon;
    float far *sqrta;
    float far *ecc;
    float far *af1;
    float far *af0;
    float far *time;
    int far *week;
    LPVOID     Index;
    } ALMANAC_PARAMS;
  
EVENTINFO Event_Almanac =
    {
    "AlmanacRecord",
    11,
    22,
    Paramtypes_Almanac,
	"cWeek as Integer, "
	"TimeOfApp as Single, "
	"AF0 as Single, "
	"AF1 as Single, "
	"Eccentricity as Single, "
	"SqrtAnom as Single, "
	"MeanAnon as Single, "
	"Parigee as Single, "
	"RightAscent as Single, "
	"RateOfRA as Single, "
	"OrbitalIncl as Single"
    };

//---------------------------------------------------------------------------
// TYPEDEF for parameters to the Download Record Event
//---------------------------------------------------------------------------
//			      type  Name   Lat,   Long,  Date   Comment
WORD Paramtypes_Download[] = {ET_I2, ET_SD, ET_I4, ET_I4, ET_I4, ET_SD,
//radis track
ET_R4, ET_I2};
   
typedef struct tag_DOWNLOAD
    {
    int far *track;
    float far *radis;
    HLSTR Comment;
    long far *date;
    long far *lon;
    long far *lat;
    HLSTR Name;
    int far *type;
    LPVOID     Index;
    } DOWNLOAD;
  
EVENTINFO Event_Download =
    {
    "Download",
    8,
    16,
    Paramtypes_Download,
	"cType as Integer, "
	"cName as String, "
	"Lat as Long, "
	"Lon as Long, "
	"cDate as Long, "
	"Comment as String, "
	"Radius as Single, "
	"TrackStart as Integer"
    };

//---------------------------------------------------------------------------
// Event list
//---------------------------------------------------------------------------
// Define the consecutive indicies for the events
//---------------------------------------------------------------------------
#define IEVENT_CIRCLE_CLICKIN		  0
#define IEVENT_CIRCLE_CLICKOUT		  1
#define IEVENT_CIRCLE_DRAGDROP		  2
#define IEVENT_CIRCLE_DRAGOVER		  3
#define IEVENT_GPS_POSITION		  4
#define IEVENT_GPS_DATE			  5
#define IEVENT_GPS_TRANSFER		  6
#define IEVENT_GPS_ALMANAC		  7
#define IEVENT_GPS_ALMANAC		  8

PEVENTINFO Circle_Events[] =
    {
    &Event_ClickIn,
    &Event_ClickOut,
    PEVENTINFO_STD_DRAGDROP,
    PEVENTINFO_STD_DRAGOVER,
    &Event_Position,
    &Event_Date,
    &Event_Transfer,
    &Event_Almanac,
    &Event_Download,
    NULL
    };


//---------------------------------------------------------------------------
// Model struct
//---------------------------------------------------------------------------
// Define the control model (using the event and property structures).
//---------------------------------------------------------------------------
MODEL modelCircle =
    {
    VB_VERSION, 			// VB version being used
    MODEL_fFocusOk | MODEL_fLoadMsg,			// MODEL flags
    (PCTLPROC)CircleCtlProc,		// Control procedure
    CS_VREDRAW | CS_HREDRAW,		// Class style
    0L, 				// Default Windows style
    sizeof(CIRC),			// Size of CIRC structure
    IDBMP_CIRCLE,			// Palette bitmap ID
    "Circle",				// Default control name
    "GPS",				// Visual Basic class name
    NULL,				// Parent class name
    Circle_Properties,			// Property information table
    Circle_Events,			// Event information table
    IPROP_CIRCLE_CIRCLESHAPE,		// Default property
    IEVENT_CIRCLE_CLICKIN,		// Default event
    IPROP_CIRCLE_CIRCLESHAPE		// Property representing value of ctl
    };

LPMODEL modellistCircle[] =
    {
    &modelCircle,
    NULL
    };

MODELINFO modelinfoCircle =
    {
    VB_VERSION, 			// VB version being used
    modellistCircle			// MODEL list
    };

#endif	// RC_INVOKED

//---------------------------------------------------------------------------
