#define VER	1.0.6
#define COM_PORT	2	// 2=com2 here only!
/*
GPS25 spits out: (by default, others can be tured on)
PGRME
GPRMC
GPGSA
GPGSV up to 3 lines
	
$PGRMV,-2.0,1.3,3*72
        east speed m/s, north speed, up speed
$PGRME,64.6,M,108.3M,126.1M*14
	horiz pos err in meters, vert pos in meters, est post in meters.
$GPRMC,032228,A,3723.0949,N,07910.0004,W,4.2,302.8,220396,008.4,W*7A
	time,A=val v=err,lat,lon,speed kts,course,date,mag var
$GPGSA,A,3,04,05,06,16,,20,24,26,,,,,2.3,1.2,1.9*38
	mode a=auto m=man,2=2d 3=3d 1=none,12 SV nums, DOP,HDOP, VDOP
$GPGSV,2,1,08,04,22,084,34,05,23,228,43,06,34,313,41,16,84,267,46*79
	no records,rec no,total SV, SV#, elevation, azimuth,S/N ratio,...
$GPGSV,2,2,08,18,08,037,36,20,26,261,41,24,55,055,46,26,12,179,35*7D
...
*/

//#define debug 01	// dump the hex values of TX and RX
#define debug 0
/*  search for XXX for things that need fixed */
// GRMN/GRMN protocol display program
//
// This works under MSC v7.0.  good luck with anything else.
// Written by Tim Hogard  9/20/95
//    This code was developed based on info from:
//	Bernard Greening <bernard@igc.apc.org>  (rs-232 code)
//	Others that wish to remain anonymous.
// This program is copy right 1996 by Tim Hogard
//	You may not make copies of this.
//	I don't want this early release being widespread.
//	You can use this for personal use (or ask me).
// Latter versions of this program will be in the public domain.
// 	If you wish to help with this please let me know.
// Find a new version at http://www.abnormal.com/~thogard
// or http://www.inmind.com/~thogard
// email:  thogard@inmind.com
// Ver: Mon May 05 1.0.6
//    Added better sat status, dop parsing
//    Inproved nmea_parse()
// Ver: Mon Apr 29 1.0.5
//    Added Com1,3,4 support -- untested! XXX
// Ver: Tue Mar 26
//    Fixed MPH speed bug
// Ver: Mon Mar 25
//    Made seperate display and parse routines
// Ver: Wed Mar 21
//    Converted to NMEA from GRMN protocol
// Ver: Mon Mar 04 22:35:16 EDT 1996
//    Added new screen layout for fields
//    added a few new packets
//    added coments for work to do.
// Ver: Wed Sep 20 09:39:59 EDT 1995
//    Inital release
//
// To exit program, type Alt-F (Windows style for Alt-F,x)
// Program works fine in 40 column mode (type "mode co40" at
//	the dos prompt; mode co80 to get back to normal). This
//	mode works nice for laptops in cars so it's readable.
// Program only works on COM2: right now.
//
// Build using:
// cl n.c graphics.lib

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <graph.h>		// requires graphics.lib
#include <signal.h>		// requires graphics.lib
#include <math.h>		// for trig

double atof(const char *);

/************************ Serial drivers *********************************/

#ifdef BORLAND  // adjust a few things for Borloand... 
/**** untested XXX on borland ****/
#define _enable() enable()
#define _disable() disable()
#define _inp(x) inportb(x)
#define _outp(x,y) outportb(x,y)
#endif	// #def BORLAND

//----------------------------
/*      Offsets to various 8250 registers.  Taken from IBM Technical         */
/*      Reference Manual, p. 1-225                                           */

#define TXBUF   0                       /* Transmit buffer register */
#define RXBUF   0                       /* Receive buffer register */
#define DLLSB   0                       /* Divisor latch LS byte */
#define DLMSB   1                       /* Divisor latch MS byte */
#define IER     1                       /* Interrupt enable register */
#define IIR     2                       /* Interrupt ID register */
#define LCR     3                       /* Line control register */
#define MCR     4                       /* Modem control register */
#define LSR     5                       /* Line status register */
#define MSR     6                       /* Modem status register */

#define INT_CTRL 0x20                    /* 8259A control port address */
#define INT_MASK 0x21                    /* 8259A interupt enable port addr */
#define EOI     0x20                    /* 8259A EOI command */
/// stuff above here should go in a .h file

// code below works on a standard com2 only.
// INT is the dos interrupr vector number
#define INT	0xb

void break_fn(int);
void (cdecl interrupt far *old_int[4])();
int __cdecl nmea_parse(const char *, const char *, ...);
int count=0;
int auto_repeat=0;
int display=0x80;	// which screen to display
			// 0x8? clears and repaints page
			// 2 basic display
			// 3 satellite screen

//port settings:  com1: com2  com3  com4
// com1 is 0x3f8; com2 is 0x2f8; com3 0x3e8; com4 0x2e8
//int port_addr[4]={0x2f8,0x2f8,0x2f8,0x2f8};	// all com2 for now
int port_addr[4]={0x3f8,0x2f8,0x3e8,0x2e8};	//com1,2,3,4
//????1011	XXX why only low nibble?
// com2/4: 11110111(f7)  com1/3: 11111011(fb)
//int port_bit[4]= { 0xf7, 0xf7, 0xf7, 0xf7};
//int port_bit[4]= { 0xf7, 0xfb, 0xf7, 0xfb};
int port_bit[4]= { 0xfb, 0xf7, 0xfb, 0xf7};
enum port_baud {b150=0x300,b300=0x1c0,b600=0xc0,b1200=0x60,b2400=0x30,
b4800=0x18,b9600=0xc,b192=0x7fe9};

char rx_buf[4][256],*rx_ptr[4];
parse_gpwpl(char *r);
void nmea_decode(unsigned char *r,int rxcount);
void nmea_display(unsigned char *r,int rxcount);

/* globals for all displays */
int svs;	// number of space vehicles
long gmt_time,date;
double latitude=0,longitude=0;
float speed=0,hdg=0,mag=0;
float dop,hdop,vdop;
int used[12];
int  rcv_status;	// 1=none, 2=2d, 3=3d
com_port=COM_PORT-1;	// 0=com1, 1=com2, 2=com3, 4=com4

struct SV_t {
	int sv;		// sat number
	int alt;	// altitude in degrees
	int brg;	// bearing
	int sn;		// signal to noise
	int used;	// is it used in current solution
} sv[32];

// This is the basis for the ISR code.
#define ISR_PROTOTYPE(y)  { 					\
	int x=y; 						\
	int s;							\
	s=inp(port_addr[x]+IIR);				\
	*rx_ptr[x]++=inp(port_addr[x]+RXBUF);			\
	outp(INT_CTRL,EOI);					\
	if(rx_ptr[x]>rx_buf[x]+sizeof(rx_buf[x])-1)		\
		rx_ptr[x]=rx_buf[x];				\
	_chain_intr(old_int[x]);				\
}		

// We must have one ISR for each interrupt since there is no way
// to pass parameters into the ISR function.
// This should be 4 functions that call one common function but
// this does not work reliably on all PCs with all compilers so
// its done the hard way.
void interrupt far isr_0() ISR_PROTOTYPE(0)
void interrupt far isr_1() ISR_PROTOTYPE(1)
void interrupt far isr_2() ISR_PROTOTYPE(2)
void interrupt far isr_3() ISR_PROTOTYPE(3)

// codes hiding in the arrays:
// EOM: end of message
// CHK_SUM: put check sum here
// START_CHK_SUM: start checksum here
// USE_ARGV: argv[1]
enum { EOM=-4, CHK_SUM, START_CHK_SUM, USE_ARGV };  // Must not be 0..255

int out_init_value[]={EOM};
int send_wpt[]={'$','P','G','W','P','L',',','3','7','2','2','.','3','7',
'7',',','N',',','0','7','9','1','0','.','4','9','5',',','W',',','B','*',
'1','B',0xa,0xd,EOM};

//char *months[]={"no0","Jan","Feb","Mar","Apr","May","Jun","Jul","Aug",
//"Sep","Oct", "Nov","Dec"};

char rxbuf[256]; int rxcount;
int *out=out_init_value;// set this var to output a message
int exit_now=0;		// set to 1 to end
//int columns;		// number of text columns

ser_open(int x)	{	// x will be 1 for com 2; for now ignore
	union REGS reg;
reg.h.al=0xe3;	// 1110 0011  E3
reg.h.ah=0;
reg.x.dx=1;
int86(0x14, &reg, &reg); // this may help windows know were using the port
	_disable();
	old_int[com_port]=_dos_getvect(INT);
	switch(com_port) {
	case 0: _dos_setvect(INT,isr_0); break;
	case 1: _dos_setvect(INT,isr_1); break;
	case 2: _dos_setvect(INT,isr_2); break;
	case 3: _dos_setvect(INT,isr_3); break;
	}
	outp(port_addr[com_port]+LCR,0x80);	// get at baud rate
	outp(port_addr[com_port]+DLLSB,b4800);
	outp(port_addr[com_port]+DLMSB,b4800>>8);
	outp(port_addr[com_port]+LCR,0x3);	// 8 bits, 1 st, np
	outp(port_addr[com_port]+IER,0x1);	// turn on Rx Interrupt
/****** there is a second 8259A for irq's 2, 8->15  XXX*******/
	outp(INT_MASK,inp(INT_MASK)&port_bit[com_port]);	// turn on 8259A irq
	outp(port_addr[com_port]+MCR,inp(port_addr[com_port]+MCR)|0x9);// Modem control register
	inp(port_addr[com_port]+RXBUF);	// flush buffer
	inp(port_addr[com_port]+RXBUF);	// flush buffer
	_enable();
}

bail() {
	_disable();
	outp(port_addr[com_port]+IER,0x0);	// turn off interrupts
	outp(INT_MASK,inp(INT_MASK)|~port_bit[com_port]);	// turn off 8259A irq
	_dos_setvect(INT,old_int[com_port]);
	_enable();
	_settextposition(24,1);
	exit(0);
}

/* GraphicsLib ******************************************************/
/*  This is here to replace microsoft's graphics.lib 
int get_cols() {		// returns graphics.lib number of columns
	struct _videoconfig vc;
	_getvideoconfig(&vc);
	return(vc.numtextcols);
}
enum {_GCLEARSCREEN} clrscrnenum;
_clearscreen(enum clrscrnenum) {
	//_GCLEARSCREEN);
}
_settextposition(y,x) {
	// y=1->25
	// x=1->80 or 1->40
}
*/

main(int argc, char **argv) {
	int c;
	int chksum=0;
	int rxcount=0;
	char *rptr;
_clearscreen(_GCLEARSCREEN);
_settextposition(20,1);
printf("Opened Com%d:\nHit Alt-F to exit\nHit F1 for help\n",com_port+1);
	rptr=rx_ptr[com_port]=rx_buf[com_port];

	signal(SIGINT,break_fn);
	signal(SIGILL,break_fn);
	signal(SIGSEGV,break_fn);
	signal(SIGTERM,break_fn);
	signal(SIGABRT,break_fn);

	ser_open(2);	// init com2:
/**** this loop is a simple multi-task loop *****/
/**** 1st dump out the output buffer        *****/
/**** 2nd get keyboard input                *****/
/**** 3rd parse input buffer                *****/
	while(1) {
		if(*out!=EOM) {
			if(inp(port_addr[com_port]+LSR)&0x20) {
			//***** need check here to see if last Tx is done
			// Check bit 0x20 of port 0x2fd before Tx
			if(*out==USE_ARGV) {	// atoi number...
				if(debug) printf("argv(%x)\n",atoi(argv[1]));
				chksum+=atoi(argv[1]);
				outp(port_addr[com_port]+TXBUF,atoi(argv[1]));
			} else if(*out==CHK_SUM) { // GRMN Checksum
				if(debug) printf("chk(%02x)\n",256-(chksum&0xff));
				outp(port_addr[com_port]+TXBUF,256-(chksum&0xff));
			} else if(*out==START_CHK_SUM) {
				chksum=0;
			} else {
				chksum+=*out;
				outp(port_addr[com_port]+TXBUF,*out);
				if(debug) printf("%02x ",*out);
			}
			out++;
			}
		}
		if(exit_now) {		// set by control-C (ctrl-break)
			bail();
		}
		while(kbhit()) {
			c=getch();
			if(c==0) {
				int x;
				c=getch();
				/* case #'s are key press codes not ascii */
				switch(c) {
				case 46: 	// alt-C (clear screen)
					display|=0x80;//set bit to clear page
					break;
				case 33: 	// alt-F (File menu)
					bail(); break;
				case 134:	// F12 Toggle repeat
					auto_repeat=!auto_repeat; break;
				case 59:	// F1 - help
					help(); break;
				case 60:	// F2 - init
					_clearscreen(_GCLEARSCREEN);
					display=2;
					break;
				case 61:	// F3 - init
					_clearscreen(_GCLEARSCREEN);
					display=0x83;
					break;
				case 62:	// F4 - 
				case 63:	// F5 - 
					_clearscreen(_GCLEARSCREEN);
					display=0x85;
					break;
				case 64:	// F6 -
				case 65:	// F7 -
				case 66:	// F8 - waypoint list (route)
					_clearscreen(_GCLEARSCREEN);
					display=0x88; break;
				case 67:	// F9 - nack
				default:
					_settextposition(24,1);
					printf("Key 0,%d pressed\n",c);
				}
			} else
			if(c==27) {	// ESC
				if(display!=0) {
					display=0x80;
					//_clearscreen(_GCLEARSCREEN); break;
				}
			} else
				outp(port_addr[com_port]+TXBUF,c);
		}
		while(rptr!=rx_ptr[com_port]) {
			c=*rptr++;
			if(rptr>rx_buf[com_port]+sizeof(rx_buf[com_port])-1)
				rptr=rx_buf[com_port];	// overflow -- reset
//			printf("%c",c);
			if (debug) printf("%02x %c ",c,c>=' '?c:'?',count);
			if(c=='$') {
				rxcount=0;
//				printf("Start:\n");
			}
			if(c!=0xa && c!=0xd) {
				rxbuf[255&rxcount++]=c;
//				printf("%c",c);
			}
			if(c==0xd) {
				rxbuf[(255&rxcount)]='\0';
				// decode data
				nmea_decode(rxbuf,rxcount);
				// display -- sometimes realtime data
				nmea_display(rxbuf,rxcount);
//				printf(": End\n");
			}
		}
	}
}

// code to decode the NMEA data.
//
void nmea_decode(unsigned char *r,int rxcount) {
	if(!strncmp("$GPGSV",r,6)) {
		int lines, ln;
		int tmp;
		int x;
		nmea_parse(&r[7], "iii", &lines,&ln,&svs);
		ln=ln-1;
		ln=ln*4;
		nmea_parse(&r[7], "iiiiiiiiiiiiiiiiiii",
		&tmp,&tmp,&tmp,
		&sv[0+ln].sv, &sv[0+ln].alt, &sv[0+ln].brg, &sv[0+ln].sn,
		&sv[1+ln].sv, &sv[1+ln].alt, &sv[1+ln].brg, &sv[1+ln].sn,
		&sv[2+ln].sv, &sv[2+ln].alt, &sv[2+ln].brg, &sv[2+ln].sn,
		&sv[3+ln].sv, &sv[3+ln].alt, &sv[3+ln].brg, &sv[3+ln].sn);
		sv[0+ln].used=sv[1+ln].used=sv[2+ln].used=sv[3+ln].used=0;
	}
	if(!strncmp("$GPRMC",r,6)) {
		char ns,ew,mw,fix;
		nmea_parse(&r[7],"TcPPffDfc",
		&gmt_time,&fix,&latitude,&longitude,&speed,&hdg,&date,&mag,&mw);
	}
//		$GPGSA,A,3,04,05,06, 16,,20,24,26,,,,,2.3,1.2,1.9*38
	if(!strncmp("$GPGSA",r,6)) {
		int i;
		char auto_mode;
		for(i=0;i<12;i++)
			used[i]=0;
		dop=hdop=vdop=0;
		nmea_parse(&r[7], "ciiiiiiiiiiiiifff", &auto_mode,&rcv_status,
			&used[0], &used[1], &used[2], &used[3], &used[4],
			&used[5], &used[6], &used[7], &used[8], &used[9],
			&used[10], &used[11], &dop, &hdop, &vdop);
	}
}

// code to do the display
//
void nmea_display(unsigned char *r,int rxcount) {
	char *x=r;
/*	for(;*x;x++)	// should check checksum here! XXX
		;
*/
	switch(display) {
	case 0x80:
		_clearscreen(_GCLEARSCREEN);
		display&=0x7f;
	case 0:
		if(!strncmp("$GPBOD",r,6)) {
			_settextposition(3,1);
			printf("\"%s\"    \n",r);
		} else if(!strncmp("$GPGGA",r,6)) {
			_settextposition(4,1);
			printf("\"%s\"    \n",r);
		} else if(!strncmp("$GPGLL",r,6)) {
			_settextposition(5,1);
			printf("\"%s\"    \n",r);
		} else if(!strncmp("$GPGSA",r,6)) {
			_settextposition(6,1);
			printf("\"%s\"    \n",r);
		} else if(!strncmp("$GPGSV",r,6)) {
			_settextposition(-1+7+r[9]-'0',1);
			printf("F5  %s  \n",r);
		} else if(!strncmp("$GPRMB",r,6)) {
			_settextposition(10,1);
			printf("\"%s\"    \n",r);
		} else if(!strncmp("$GPRMC",r,6)) {
			_settextposition(11,1);
			printf("\"%s\"    \n",r);
		} else if(!strncmp("$PGRMV",r,6)) {
			_settextposition(12,1);
			printf("\"%s\"  \n",r);
		} else if(!strncmp("$GPWPL",r,6)) {
			_settextposition(12,1);
			printf("F8  %s  \n",r);
		} else if(!strncmp("$PGRME",r,6)) {
			_settextposition(13,1);
			printf("\"%s\"    \n",r);
		} else if(!strncmp("$PGRMM",r,6)) {
			_settextposition(14,1);
			printf("\"%s\"    \n",r);
		} else if(!strncmp("$PGRMZ",r,6)) {
			_settextposition(15,1);
			printf("\"%s\"    \n",r);
		} else if(!strncmp("$GPRTE",r,6)) {	// 15,16,17,18
			_settextposition(-1+16+r[9]-'0',1);
	//		_settextposition(16,1);
			printf("\"%s\"    \n",r);
		} else if(!strncmp("$GPVTG",r,6)) {	// 183 1.5
			_settextposition(20,1);
			printf("\"%s\"    \n",r);
		} else if(!strncmp("$GPBWC",r,6)) {	// 183 1.5
			_settextposition(21,1);
			printf("\"%s\"    \n",r);
		} else if(!strncmp("$GPXTE",r,6)) {	// 183 1.5
			_settextposition(22,1);
			printf("\"%s\"    \n",r);
		} else {
			_settextposition(23,1);
			printf("%-78.78s \n",r);
		}
		break;
	case 0x82:
		_clearscreen(_GCLEARSCREEN);
		display&=0x7f;
	case 2:
//xxxxxxxxxxxxxxxxxxxxxxxxxx
//$GPRMC,032228,A,3723.0949,N,07910.0004,W,4.2,302.8,220396,008.4,W*7A
		if(!strncmp("$GPRMC",r,6)) {
			int x;
			int y=date%100;
			int mo=(date/100)%100;
			int d=(date/10000)%100;
			int s=gmt_time%100;
			int m=(gmt_time/100)%100;
			int h=(gmt_time/10000)%100;
			_settextposition(2,1);
			printf("Speed: %.1f    %.1f\n",speed,speed*1.15);//*mph
			printf("%i/%2i/%2i %02d:%02d:%02d\n",mo,d,y,h,m,s);
			printf("%9.4f %9.4f\n",latitude,longitude);
			printf("Hdg: %.1f\n",hdg);
			printf("\"%s\"    \n",r);
			for(x=0;x<39;x++)
				if(x<speed/2)
					printf("*");
				else
					printf(" ");
			printf("\n");
			for(x=0;x<39;x++)
				if(x<speed/5)
					printf("*");
				else
					printf(" ");
			printf("\n");

printf("DOPs %f %f %f stat(%d)\n",dop,hdop,vdop,rcv_status);
		}
		break;
	case 0x85:
	case 0x83:
		_clearscreen(_GCLEARSCREEN);
		{
			int x;
			_settextposition(11,20);
			printf("*");
			for(x=0;x<360;x+=5) {
				_settextposition(
				11-(int)(cos(x*3.1415926*2/360)*7),
				20+(int)(sin(x*3.1415926*2/360)*10));
				printf(".");
			}
			for(x=0;x<360;x+=5) {
				_settextposition(
				11-(int)(.5*cos(x*3.1415926*2/360)*7),
				20+(int)(.5*sin(x*3.1415926*2/360)*10));
				printf(".");
			}
		}
		display&=0x7f;
	case 3:
	case 5:
		if(!strncmp("$GPGSV",r,6)) {
			int x;
				_settextposition(4,1);
//				for(x=0;x<svs;x++)
//					printf("Sv: %d @ (%d,%d) %d  \n",sv[x].sv,sv[x].alt,sv[x].brg,sv[x].sn);
				for(x=0;x<svs;x++) {
					int y;
					for(y=27;y<50;y+=3) {
						_settextposition(23-(y-27)/3,3*x+1);
						if(y<sv[x].sn)
							printf("*");
						else
							printf(" ");
					}

					_settextposition(23,3*x+1);
					printf("%d",sv[x].sv);
				}
				// display at (20,11)
				for(x=0;x<svs;x++) {
					_settextposition(
11-(int)(cos(sv[x].alt*3.1415926*2/360)*cos(sv[x].brg*3.1415926*2/360)*7),
20+(int)(cos(sv[x].alt*3.1415926*2/360)*sin(sv[x].brg*3.1415926*2/360)*10));
					printf("%d",sv[x].sv);
				}
				_settextposition(1,1);
				printf("DOPs %.1f h%.1f v%.1f stat(%d)\n",dop,hdop,vdop,rcv_status);
				_settextposition(24,1);
				for(x=0;x<12;x++)
					if(used[x])
						printf("%-2d ",used[x]);
					else
						printf("   ");
		}
		break;
	case 0x88:
		display&=0x7f;
		_clearscreen(_GCLEARSCREEN);
	case 8:
		if(!strncmp("$GPWPL",r,6)) {
			_settextposition(1,1);
			printf("%s   \n",r);
			parse_gpwpl(r);
		}
		break;
	default:

		break;
	}
}

struct WPT_t {
	char name[7];
	double lat,lon;
} wpt[100];
int wpts=0;
parse_gpwpl(char *r) {
	int x;
	char ns,ew;
	int found=0;
	struct WPT_t w;
//F8  $GPWPL,3816.484,N,08557.728,W,RAIN4W*28  
	sscanf(&r[7],"%lg,%c,%lg,%c,%s*",&w.lat,&ns,&w.lon,&ew,&w.name[0]);
	printf("Name: %s (%f,%f)  \n",w.name,w.lat,w.lon);
	for(x=0;x<wpts;x++) {
		if(!strcmp(w.name,wpt[x].name)) {
			wpt[x].lat=w.lat;
			wpt[x].lon=w.lon;
			found=1;
		}
		printf(" %12s  %4.4f %8.4f\n",wpt[x].name,wpt[x].lat,wpt[x].lon);
	}
	if(!found) {
		strncpy(wpt[x].name,w.name,sizeof(w.name));
		wpt[x].lat=w.lat;
		wpt[x].lon=w.lon;
		printf("ADD %12s  %4.4f %8.4f\n",wpt[x].name,wpt[x].lat,wpt[x].lon);
		printf("wpts=%d\n",wpts);
wpts++;
	}
}

void break_fn(int i) {
	exit_now=1;
}

help() {
	printf("Hit Alt-F to exit (from Alt-F X to exit like win programs)\n\n");
	printf("F1-Help\n");
	printf("F2-Basic Speed Display\n");
	printf("F3-View Sat screen\n");
	printf("F8-View Waypoints\n");
	printf("F12-Auto repeat\n");
	printf("Alt-C  Clear screen\n");
}

/* users manual:
At dos type:
c:\> n number
(the number is used by some commands for expirmental use)

Press F1 to get help.

Press Alt-F (or Ctrl-C or ctrl-break) to exit.

*/

#include <stdarg.h>
//sscanf(&r[7],"%ld,%c,%f,%c,%f,%c,%f,%f,%ld,%f,%c",
//sscan(in_buf,prototype,stuff...)
// Protocol:
// H: Header    $AAAAA
// P: Position  dddmm.mmmm,h	double   (- for south and west)
// T: Time	hhmmss		long
// D: Date	yymmdd		long
// i: integer	-32K->32K	int
// c: character	single char
// s: string
// f: float			float
// g: double			double
int __cdecl nmea_parse(const char *in_buf, const char *prototype, void *first,...) {
	int count=0;
	void *val;
	void far *val1;
	char *str;
	unsigned int u;
	va_list marker;
	va_start(marker,prototype);
	while(*prototype) {
		switch(*prototype++) {
		case 'H': // Header $AAAAA	//XXX
			val=va_arg(marker,void *);
			str=val;
			*str++='$';
			*str++=*in_buf++;	// $
			*str++=*in_buf++; *str++=*in_buf++;	// ch 1,2
			*str++=*in_buf++; *str++=*in_buf++;	// ch 3,4
			*str++=*in_buf++;			// ch 5
			*str++='\0';
			count++;
			break;
		case 'P': // Position  dddmm.mmmm  // a double
			val=va_arg(marker,void *);
			*(double *)val=atof(in_buf);
			while(*in_buf!=','&&*in_buf!='*'&&*in_buf!='\0')
				in_buf++;
			in_buf++;
//			in_buf++;
			if(*in_buf=='S'||*in_buf=='W')	// XXX is this correct?
				*(double *)val=-*(double *)val;
			break;
		case 'T': // Time	hhmmss	// a long
			val=va_arg(marker,void *);
			*(long *)val=atol(in_buf);
			break;
		case 'D': // Date	yymmdd	// a long
			val=va_arg(marker,void *);
			*(long *)val=atol(in_buf);
			break;
		case 'i': // integer	-32K->32K
			val=va_arg(marker,int *);
			*(int *)val=atoi(in_buf);
			break;
		case 'c': // character	single char
			val=va_arg(marker,void *);
			*(char *)val=*in_buf++;
			break;
		case 's': // string	//XXX
			val=va_arg(marker,void *);
			str=val;
			while(*in_buf!=','&&*in_buf!='*'&&*in_buf!='\0')
				*str++=*in_buf++;
			*str++='\0';
			break;
		case 'f': // float
			val=va_arg(marker,void *);
			*(float *)val=atof(in_buf);
			break;
		case 'g': // double
			val=va_arg(marker,void *);
			*(double *)val=atof(in_buf);
			break;
		default:
			printf("Bad value in nmea_parse\n");
			val=va_arg(marker,void *);
			break;
		}
		while(*in_buf!=','&&*in_buf!='*'&&*in_buf!='\0')
			in_buf++;
		if(*in_buf==',')	// next
			in_buf++;	// point to next char
		if(*in_buf=='*')	// checksum here
			break;		// return count
	}
	va_end(marker);
}


/*
$GPRMC,031158,V,,,,,,,240396,,*35    
$GPRMB,V,,,,,,,,,,,,V*66    
$GPGGA,031158,,,,,0,00,,,M,,M,,*68    
$GPGSA,A,1,,,,,,,,,,,,,,,*1E    
$PGRME,,M,,M,,M*00    
$GPGLL,,,,,031158,*5E    
$PGRMZ,,,*7E    
$PGRMM,WGS 84*06    
$GPBOD,,T,,M,,*47    
$GPRTE,1,1,c,0*07    
$GPRMC,031200,V,,,,,,,240396,,*3B    
$GPGSV,2,1,08,04,23,083,00,05,24,230,00,06,33,314,00,16,83,254,00*71
$GPGSV,2,2,08,18,08,038,00,20,27,263,00,24,55,055,00,26,11,179,00*76

$GPGSA,A,3,06,16,,,24,26,,,,,,,4.7,2.3,4.0*37    
$GPRMC,050739,A,3723.1073,N,07910.0890,W,0.0,326.3,240396,008.4,W*72    
$GPRMC,050747,A,3723.1028,N,07910.0874,W,0.0,326.3,240396,008.4,W*7F    
$PGRME,77.9,M,134.7,M,155.6,M*11    
$PGRME,97.7,M,,M,97.7,M*00    
$PGRMV,0.1,-0.0,-0.0*5D		//   -0.0?????
$PGRMV,0.1,0.0,-0.0*70
$PGRMV,0.2,-0.1,0.1*73
*/
